---@meta

---@class FChangeClientStreamFrequencyResponse
---@field ObjectErrors TMap<FSoftObjectPath, EMultiUserChangeFrequencyErrorCode>
---@field DefaultChangeErrorCode TOptional<EMultiUserChangeFrequencyErrorCode>
local FChangeClientStreamFrequencyResponse = {}



---@class FConcertBlueprintEvent
---@field Data FConcertSessionSerializedPayload
local FConcertBlueprintEvent = {}



---@class FMultiUserBlueprintEventData
local FMultiUserBlueprintEventData = {}


---@class FMultiUserChangeAuthorityRequest
---@field ObjectsToStartReplicating TSet<FSoftObjectPath>
---@field ObjectToStopReplicating TSet<FSoftObjectPath>
local FMultiUserChangeAuthorityRequest = {}



---@class FMultiUserChangeClientAuthorityResponse
---@field errorCode EMultiUserChangeAuthorityOperationResult
---@field RejectedObjects TSet<FSoftObjectPath>
local FMultiUserChangeClientAuthorityResponse = {}



---@class FMultiUserChangeClientReplicationRequest
---@field StreamChangeRequest FMultiUserChangeStreamRequest
---@field AuthorityChangeRequest FMultiUserChangeAuthorityRequest
local FMultiUserChangeClientReplicationRequest = {}



---@class FMultiUserChangeClientReplicationResult
---@field StreamResponse FMultiUserChangeClientStreamResponse
---@field AuthorityResponse FMultiUserChangeClientAuthorityResponse
local FMultiUserChangeClientReplicationResult = {}



---@class FMultiUserChangeClientStreamResponse
---@field errorCode EMultiUserChangeStreamOperationResult
---@field AuthorityConflicts TMap<FSoftObjectPath, FGuid>
---@field SemanticErrors TMap<FSoftObjectPath, EMultiUserPutObjectErrorCode>
---@field FrequencyErrors FChangeClientStreamFrequencyResponse
---@field bFailedStreamCreation boolean
local FMultiUserChangeClientStreamResponse = {}



---@class FMultiUserChangeStreamRequest
---@field PropertyChanges TMap<UObject, FMultiUserPropertyChange>
---@field ObjectsToRemove TSet<FSoftObjectPath>
---@field FrequencyChanges FMultiUserFrequencyChangeRequest
local FMultiUserChangeStreamRequest = {}



---@class FMultiUserClientConfig
---@field DefaultServerURL FString
---@field DefaultSessionName FString
---@field DefaultSessionToRestore FString
---@field ValidationMode EMultiUserSourceValidationMode
local FMultiUserClientConfig = {}



---@class FMultiUserClientInfo
---@field ClientEndpointId FGuid
---@field DisplayName FString
---@field AvatarColor FLinearColor
---@field Tags TArray<FName>
local FMultiUserClientInfo = {}



---@class FMultiUserConnectionError
---@field errorCode EMultiUserConnectionError
---@field ErrorMessage FText
local FMultiUserConnectionError = {}



---@class FMultiUserFrequencyChangeRequest
---@field OverridesToRemove TSet<FSoftObjectPath>
---@field OverridesToAdd TMap<FSoftObjectPath, FMultiUserObjectReplicationSettings>
---@field NewDefaults FMultiUserObjectReplicationSettings
---@field bChangeDefaults boolean
local FMultiUserFrequencyChangeRequest = {}



---@class FMultiUserObjectReplicationSettings
---@field Mode EMultiUserObjectReplicationMode
---@field ReplicationRate uint8
local FMultiUserObjectReplicationSettings = {}



---@class FMultiUserPropertyChange
---@field Properties TArray<FConcertPropertyChainWrapper>
---@field ChangeType EMultiUserPropertyChangeType
local FMultiUserPropertyChange = {}



---@class FMultiUserReplicationRegistrationParams
---@field ClientEndpointId FGuid
---@field Context TScriptInterface<IMultiUserReplicationRegistrationContext>
local FMultiUserReplicationRegistrationParams = {}



---@class FMultiUserSessionInfo
---@field ServerEndpointId FGuid
---@field SessionName FString
---@field serverName FString
---@field EndpointName FString
---@field bValid boolean
local FMultiUserSessionInfo = {}



---@class IMultiUserReplicationRegistration : IInterface
local IMultiUserReplicationRegistration = {}

---@param Params FMultiUserReplicationRegistrationParams
function IMultiUserReplicationRegistration:DiscoverReplicationSettings(Params) end


---@class IMultiUserReplicationRegistrationContext : IInterface
local IMultiUserReplicationRegistrationContext = {}

---@param Object UObject
---@param PropertiesToAdd TArray<FConcertPropertyChainWrapper>
function IMultiUserReplicationRegistrationContext:AddPropertiesToObject(Object, PropertiesToAdd) end
---@param Object UObject
function IMultiUserReplicationRegistrationContext:AddAdditionalObject(Object) end


---@class UChangeClientAsyncAction : UBlueprintAsyncActionBase
---@field OnCompleted FChangeClientAsyncActionOnCompleted
---@field ClientId FGuid
---@field ReplicationRequest FMultiUserChangeClientReplicationRequest
local UChangeClientAsyncAction = {}

---@param Response FMultiUserChangeClientReplicationResult
function UChangeClientAsyncAction:OnChangeOperationCompleted__DelegateSignature(Response) end
---@param ClientId FGuid
---@param Request FMultiUserChangeClientReplicationRequest
---@return UChangeClientAsyncAction
function UChangeClientAsyncAction:ChangeClient(ClientId, Request) end


---@class UMultiUserClientStatics : UBlueprintFunctionLibrary
local UMultiUserClientStatics = {}

function UMultiUserClientStatics:UpdateWorkspaceModifiedPackages() end
---@return boolean
function UMultiUserClientStatics:StartMultiUserDefaultConnection() end
---@param ClientEndpointId FGuid
---@param Visibility boolean
---@param PropagateToAll boolean
function UMultiUserClientStatics:SetMultiUserPresenceVisibilityById(ClientEndpointId, Visibility, PropagateToAll) end
---@param Name FString
---@param Visibility boolean
---@param PropagateToAll boolean
function UMultiUserClientStatics:SetMultiUserPresenceVisibility(Name, Visibility, PropagateToAll) end
---@param IsEnabled boolean
function UMultiUserClientStatics:SetMultiUserPresenceEnabled(IsEnabled) end
---@param PackagesToPersist TArray<FName>
function UMultiUserClientStatics:PersistSpecifiedPackages(PackagesToPersist) end
function UMultiUserClientStatics:PersistMultiUserSessionChanges() end
---@param OtherUserName FString
---@param TransformOffset FTransform
function UMultiUserClientStatics:JumpToMultiUserPresence(OtherUserName, TransformOffset) end
---@param ClientInfos TArray<FMultiUserClientInfo>
---@return boolean
function UMultiUserClientStatics:GetRemoteMultiUserClientInfos(ClientInfos) end
---@return FMultiUserSessionInfo
function UMultiUserClientStatics:GetMultiUserSessionInfo() end
---@param ClientEndpointId FGuid
---@return FTransform
function UMultiUserClientStatics:GetMultiUserPresenceTransform(ClientEndpointId) end
---@return EMultiUserConnectionStatus
function UMultiUserClientStatics:GetMultiUserConnectionStatusDetail() end
---@return boolean
function UMultiUserClientStatics:GetMultiUserConnectionStatus() end
---@param ClientName FString
---@param ClientInfo FMultiUserClientInfo
---@return boolean
function UMultiUserClientStatics:GetMultiUserClientInfoByName(ClientName, ClientInfo) end
---@return FMultiUserClientInfo
function UMultiUserClientStatics:GetLocalMultiUserClientInfo() end
---@return FMultiUserConnectionError
function UMultiUserClientStatics:GetLastMultiUserConnectionError() end
---@return UMultiUserClientSyncDatabase
function UMultiUserClientStatics:GetConcertSyncDatabase() end
---@param IgnorePersisted boolean
---@return TArray<FName>
function UMultiUserClientStatics:GatherSessionChanges(IgnorePersisted) end
---@param ClientConfig FMultiUserClientConfig
---@return boolean
function UMultiUserClientStatics:ConfigureMultiUserClient(ClientConfig) end


---@class UMultiUserClientSyncDatabase : UObject
---@field OnPackageSaved FMultiUserClientSyncDatabaseOnPackageSaved
local UMultiUserClientSyncDatabase = {}



---@class UMultiUserReplicationRegistrationContextImpl : UObject
local UMultiUserReplicationRegistrationContextImpl = {}

---@param Object UObject
---@param PropertiesToAdd TArray<FConcertPropertyChainWrapper>
function UMultiUserReplicationRegistrationContextImpl:AddPropertiesToObject(Object, PropertiesToAdd) end
---@param Object UObject
function UMultiUserReplicationRegistrationContextImpl:AddAdditionalObject(Object) end


---@class UMultiUserReplicationSubsystem : UEngineSubsystem
---@field OnClientStreamServerStateChanged FMultiUserReplicationSubsystemOnClientStreamServerStateChanged
---@field OnClientAuthorityServerStateChanged FMultiUserReplicationSubsystemOnClientAuthorityServerStateChanged
local UMultiUserReplicationSubsystem = {}

---@param EndpointId FGuid
function UMultiUserReplicationSubsystem:OnServerStateChanged__DelegateSignature(EndpointId) end
---@param ClientId FGuid
---@param ObjectPath FSoftObjectPath
---@return boolean
function UMultiUserReplicationSubsystem:IsReplicatingObject(ClientId, ObjectPath) end
---@param ClientId FGuid
---@return TArray<FSoftObjectPath>
function UMultiUserReplicationSubsystem:GetReplicatedObjects(ClientId) end
---@param ClientId FGuid
---@return TArray<FSoftObjectPath>
function UMultiUserReplicationSubsystem:GetRegisteredObjects(ClientId) end
---@param ClientId FGuid
---@param ObjectPath FSoftObjectPath
---@return TArray<FConcertPropertyChainWrapper>
function UMultiUserReplicationSubsystem:GetPropertiesRegisteredToObject(ClientId, ObjectPath) end
---@param ClientId FGuid
---@param ObjectPath FSoftObjectPath
---@param OutFrequency FMultiUserObjectReplicationSettings
---@return boolean
function UMultiUserReplicationSubsystem:GetObjectReplicationFrequency(ClientId, ObjectPath, OutFrequency) end


---@class UMultiUserSubsystem : UEngineSubsystem
---@field OnSessionConnected FMultiUserSubsystemOnSessionConnected
---@field OnSessionDisconnected FMultiUserSubsystemOnSessionDisconnected
---@field OnSessionClientChanged FMultiUserSubsystemOnSessionClientChanged
local UMultiUserSubsystem = {}

---@param EventType UStruct
---@return boolean
function UMultiUserSubsystem:UnregisterCustomEventHandler(EventType) end
---@param EventType UStruct
---@param InEventHandler FRegisterCustomEventHandlerInEventHandler
---@return boolean
function UMultiUserSubsystem:RegisterCustomEventHandler(EventType, InEventHandler) end
---@param EventData int32
function UMultiUserSubsystem:K2_SendCustomEvent(EventData) end
---@param EventData FMultiUserBlueprintEventData
---@param StructOut int32
function UMultiUserSubsystem:K2_ExtractEventData(EventData, StructOut) end
---@return boolean
function UMultiUserSubsystem:IsConnectedToSession() end
---@param OutRemoteClientIds TArray<FGuid>
---@return boolean
function UMultiUserSubsystem:GetRemoteClientIds(OutRemoteClientIds) end
---@param OutClientId FGuid
---@return boolean
function UMultiUserSubsystem:GetLocalClientId(OutClientId) end


